@echo off
rem by: Kevin (Truglodite)
rem This script automates flashing an HK G-OSD II unit with CL-OSD firmware.
rem It requires avrdude, which is part of WinAVR, AVR Studio 5, and an online browser for Google maps.
rem Please add the required definition to avrdude.conf if you get signature errors (the m88pa chip isn't defined).
rem Open this script from your GOSD folder (in CL-OSD)
 

cd %~dp0
echo %~dp0

start cl-osd.atsln
start https://maps.google.com/
start %windir%\system32\calc.exe
echo AVR Studio 5, Google Maps, and Calculator started...
echo.
echo.
echo.
echo *******************************************************************************
echo.
echo -Prepare the board to flash the zero calibration firmware
echo.
echo *******************************************************************************
echo.
echo.
echo.
pause
echo.
echo.
echo.
avrdude.exe -p m88pa -c usbasp -U flash:w:cl-osd0.hex -U eeprom:w:cl-osd0.eep
echo.
echo.
echo.
echo *******************************************************************************
echo.
echo -Power up the OSD and write down the displayed coordinates after GPS lock
echo -Look up your actual Google Maps coordinates online
echo -Subtract Google - displayed coordinates; these are your calibration values
echo -Enter your calibration values in the "FUDGE_GOOGLE_..." lines and compile
echo -Prepare the board to flash "cl-osd"
echo.
echo *******************************************************************************
echo.
echo.
echo.
pause
echo.
echo.
echo.
avrdude.exe -p m88pa -c usbasp -U flash:w:cl-osd.hex -U eeprom:w:cl-osd.eep
echo.
echo.
echo.
echo *******************************************************************************
echo *******************************************************************************
echo *******************************************************************************
echo.
echo Ready To Fly!!! 
echo.
echo *******************************************************************************
echo *******************************************************************************
echo *******************************************************************************
echo.
echo.
echo.